/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Runtime.Serialization;

namespace Borland.Eco.Exceptions
{
	[Serializable]
	public class EcoException: Exception
	{
		public EcoException(): base() {}
		public EcoException(string message): base(message) {}
		public EcoException(string message, Exception inner): base(message, inner) {}
#if !CF
		protected EcoException(SerializationInfo info, StreamingContext context): base(info, context) {}
#endif
	}
	[Serializable]
	public class InvalidMappingException: EcoException
	{
		public InvalidMappingException(): base() {}
		public InvalidMappingException(string message): base(message) {}
		public InvalidMappingException(string message, Exception inner): base(message, inner) {}
#if !CF
		protected InvalidMappingException(SerializationInfo info, StreamingContext context): base(info, context) {}
#endif
	}
	[Serializable]
	public class BadLockExpressionException: EcoException
	{
		public BadLockExpressionException(): base() {}
		public BadLockExpressionException(string message): base(message) {}
		public BadLockExpressionException(string message, Exception inner): base(message, inner) {}
#if !CF
		protected BadLockExpressionException(SerializationInfo info, StreamingContext context): base(info, context) {}
#endif
	}
}   